<?php

namespace App\Services\Users;

use App\Adapter\Users\Email\UserNotificationsInterface;
use App\Core\Exception\ApiException;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Users\User;
use App\Entity\Users\UsersInterface;
use App\Models\Users\UserModel;
use Symfony\Contracts\Translation\TranslatorInterface;

class ResetPassword
{
    public function __construct(
        private UsersInterface $users,
        private TransactionInterface $transaction,
        private UserNotificationsInterface $notifications,
        private TranslatorInterface $translator
    ) {}

    public function sendToken(UserModel $userModel): void
    {
        $user = $this->users->findOneByEmail($userModel->getEmail());
        if (!$user || $user->getIsNotActive()) {
            return;
        }

        $this->transaction->begin();

        $user->generateToken();

        $this->notifications->sendResetPasswordEmail($user);

        $this->transaction->end();
    }

    /** @throws ApiException */
    public function resetPassword(User $user, UserModel $userModel): void
    {
        if ($user->getIsNotActive()) {
            throw new ApiException($this->translator->trans('account.not_activated'));
        }

        $this->transaction->begin();

        $user->setPassword($userModel->getPassword());
        $user->clearToken();

        $this->transaction->end();
    }
}