<?php

namespace App\Services\Units;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Subscriptions\Classes\SubscriptionManagerInterface;
use App\Entity\Units\Unit;

class UpdateUnitStatus
{
    public function __construct(
        private TransactionInterface $transaction,
        private SubscriptionManagerInterface $subscriptionManager
    )
    {
    }

    public function publish(Unit $unit): void
    {
        $this->transaction->begin();

        $unit->publish();

        $this->transaction->end();
    }

    public function unpublish(Unit $unit)
    {
        $this->transaction->begin();

        $unit->unpublish();
        $this->subscriptionManager->deactivateSubscriptionsByUnit($unit);

        $this->transaction->end();
    }

}