<?php

namespace App\Services\Reports;

use App\Core\PdfGenerator\PDFBuilder;
use App\Core\PdfGenerator\PDFFile;
use App\Core\PdfGenerator\PDFGeneratorInterface;
use App\Entity\Reports\Helper\AnnualReportParameters;
use App\Entity\Reports\Helper\GenerateFilename;
use App\Entity\Reports\ReadModel\ReportsQueryInterface;
use App\Entity\Users\User;
use App\Models\Reports\RequestDatesModel;

class GenerateAnnualReportPDF
{
    private const ANNUAL_REPORT_TWIG = 'pdf/annual_report.html.twig';

    public function __construct(
        private PDFGeneratorInterface $PDFGenerator,
        private ReportsQueryInterface $reportsQuery,
        private string $filePath
    )
    {
    }

    public function generate(User $user, RequestDatesModel $model): PDFFile
    {
        $data = $this->reportsQuery->getAnnualReportDataByUserID($user->getUuid(), $model->getYear());
        $parameters = new AnnualReportParameters(
            $model->getYear(),
            $user->getName(),
            $user->getSurname(),
            $user->getEmail(),
            $data
        );
        $PDFFile = PDFBuilder::create(
            GenerateFilename::annualReportPDFFilename((string)$user->getUuid()),
            $this->filePath,
            self::ANNUAL_REPORT_TWIG
        )
            ->setTwigParameters($parameters)
            ->build();

        $this->PDFGenerator->generate($PDFFile);

        return $PDFFile;
    }
}