<?php

namespace App\Services\Posts;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Posts\Post;

class UpdatePostStatus
{
    public function __construct(
        private TransactionInterface $transaction
    )
    {
    }

    public function publish(Post $post): void
    {
        $this->transaction->begin();

        $post->publish();

        $this->transaction->end();
    }

    public function unpublish(Post $post)
    {
        $this->transaction->begin();

        $post->unpublish();

        $this->transaction->end();
    }

}