<?php

namespace App\Services\Posts;

use App\Core\Exception\ApiException;
use App\Core\File\ImageManager\ImageManagerInterface;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Posts\Post;
use App\Models\Posts\PostModel;

class UpdatePost
{
    public function __construct(
        private TransactionInterface $transaction,
        private ImageManagerInterface  $imageManager
    ) {}

    /**
     * @throws ApiException
     */
    public function update(Post $post, PostModel $postModel): void
    {
        $this->transaction->begin();

        if ($post->isNotActive()) {
            throw new ApiException('Post does not exist');
        }

        $post->updateData(
            $postModel->getTitle(),
            $postModel->getDescription(),
            $postModel->getContent()
        );

        $image = $this->imageManager->prepare(
            $post->getPhoto(),
            $postModel->getPhoto()
        );
        $post->updatePhoto($image);

        $this->transaction->end();
    }
}