<?php

namespace App\Services\Orders\Webhooks;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Orders\Classes\OrderManagerInterface;
use App\Entity\Orders\Events\OrderVerifyEvent;
use App\Entity\Orders\Order;
use Psr\EventDispatcher\EventDispatcherInterface;

class VerifyRenewSubscriptionOrder
{
    public function __construct(
        private VerifyOrder $verifyOrder,
        private TransactionInterface $transaction,
        private OrderManagerInterface $orderManager
    )
    {
    }

    public function verifyRenewSubscription(Order $order): Order
    {
        //TODO number of transactions

        $order = $this->verifyOrder->verify($order);

        $this->transaction->begin();

        $this->orderManager->renewSubscription($order);

        $this->transaction->end();

        return $order;
    }
}