<?php

namespace App\Services\Orders;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Orders\Helper\OrderStatus;
use App\Entity\Subscriptions\Helper\ReasonForClosure;
use App\Entity\Subscriptions\Subscription;
use Psr\Log\LoggerInterface;

class SubscriptionUnpaid
{
    public function __construct(
        private TransactionInterface $transaction,
        private LoggerInterface $paymentLogger,
    )
    {
    }

    public function unpaid(Subscription $subscription)
    {
        $dateNow = new \DateTimeImmutable();


        $this->transaction->begin();

        $subscription->deactivate(ReasonForClosure::UNPAID);
        $subscription->getBasicOrderID()->setStatus(OrderStatus::ERROR);

        $this->transaction->end();


        $this->paymentLogger->info('Success deactivation subscription:' . $subscription->getUuid() . 'with reason: '.ReasonForClosure::UNPAID.' at date: ' . $dateNow->format("Y-m-d H:i:s"));
    }
}