<?php

namespace App\Services\Galleries;

use App\Core\File\FileToUpload\FileToUploadInterface;
use App\Core\File\ImageManager\ImageManagerInterface;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Images\ImagesInterface;
use App\Entity\Units\Unit;
use App\Models\Gallery\GalleryPhotosModel;

class UploadPhotos
{
    public function __construct(
        private TransactionInterface $transaction,
        private ImagesInterface $images,

        private ImageManagerInterface $imageManager
    ) {}

    public function upload(Unit $unit, GalleryPhotosModel $galleryPhotosModel): void
    {
        $this->transaction->begin();

        /** @var FileToUploadInterface $galleryPhoto */
        foreach ($galleryPhotosModel->getPhotos() as $galleryPhoto) {
            $photo = $this->imageManager->prepare(imageToUpload: $galleryPhoto);
            $photo->setUnit($unit);

            $this->images->add($photo);
        }

        $this->transaction->end();
    }
}