<?php

namespace App\PaymentSystem;

use App\PaymentSystem\Api\Request\ApiRequest;

class TransactionVerification extends ApiRequest
{
    /**
     * @var array
     */
    protected $signatureAttributes = [
        'sessionId',
        'orderId',
        'amount',
        'currency',
        'crc',
    ];

    /**
     * @param array $parameters
     */
    public function __construct(array $parameters = [])
    {
        $this->parameters = array_merge([
            'currency' => 'PLN',
        ], $parameters);
    }
}
