<?php

namespace App\PaymentSystem\Helper;

use App\PaymentSystem\Exceptions\TransactionNumberNotFoundException;

class P24Finder
{
    private const TRANSACTION_NUMBER_REGEX = '{(p|P)24-.{11}}';

    /**
     * @throws TransactionNumberNotFoundException
     */
    public static function findTransactionNumberByStatement(string $statement, string $regex = self::TRANSACTION_NUMBER_REGEX): string
    {
        preg_match($regex, $statement, $matches);

        return $matches[0] ?? throw  new TransactionNumberNotFoundException();
    }
}