<?php

namespace App\PaymentSystem\Api\Response;

use App\PaymentSystem\Exceptions\ApiResponseException;
use Psr\Http\Message\ResponseInterface;

abstract class ApiResponse
{
    /**
     * @var string
     */
    protected $error;

    /**
     * @var int
     */
    protected $code = 0;

    /**
     * @param ResponseInterface $response
     * @throws ApiResponseException
     */
    public function __construct(ResponseInterface $response)
    {

        $contents = $response->getBody();
        $this->setCode($response->getStatusCode());

        $parameters = json_decode($contents, true);
        $data = $this->getData($parameters);

        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }

        if ($this->hasError()) {
            throw new ApiResponseException(
                $this->getError(),
                $this->getCode()
            );
        }


    }

    /**
     * @return bool
     */
    protected function hasError(): bool
    {
        return !empty($this->error);
    }

    /**
     * @return string|null
     */
    protected function getError(): ?string
    {
        return $this->error;
    }

    /**
     * @return int
     */
    protected function getCode(): int
    {
        return $this->code;
    }

    private function getData(array $parameters): array
    {
        return isset($parameters['data']) && is_array($parameters['data']) ? $parameters['data'] : $parameters;
    }

    private function setCode(int $code)
    {
        return $this->code = $code;
    }
}
