<?php

namespace App\Models\Reports;

use App\Core\ParamConverter\JsonModelConverter;
use Symfony\Component\Validator\Constraints as Assert;

class RequestDatesModel implements JsonModelConverter
{
    /** @var string|null */
    #[Assert\Date]
    private ?string $dateStart;

    /** @var string|null */
    #[Assert\Date]
    private ?string $dateEnd;

    /** @var int|null */
    #[Assert\DateTime(format: 'Y')]
    #[Assert\Positive]
    private ?int $year;

    /**
     * @param string|null $dateStart
     * @param string|null $dateEnd
     */
    public function __construct(?string $dateStart = null, ?string $dateEnd = null, ?int $year = null)
    {
        $this->dateStart = $dateStart;
        $this->dateEnd = $dateEnd;
        $this->year = $year;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getDateStart(): ?\DateTimeImmutable
    {
        if ($this->dateStart)
            return new \DateTimeImmutable($this->dateStart);

        return null;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getDateEnd(): ?\DateTimeImmutable
    {
        if ($this->dateEnd)
            return new \DateTimeImmutable($this->dateEnd);

        return null;
    }

    /**
     * @return int|null
     */
    public function getYear(): ?int
    {
        return $this->year;
    }


}