<?php

namespace App\Models\Reports;

use App\Core\ParamConverter\JsonModelConverter;
use App\Entity\Reports\Helper\ReportName;
use App\Entity\Reports\ReadModel\QuarterReportRecipientDTO;
use Symfony\Component\Notifier\Recipient\EmailRecipientInterface;
use Symfony\Component\Validator\Constraints as Assert;

class RecipientReportModel extends ReportModel implements JsonModelConverter, EmailRecipientInterface
{

    #[Assert\NotBlank]
    #[Assert\Email]
    private string $email;

    #[Assert\NotBlank]
    #[Assert\Length(max: 50)]
    private string $name;

    public function __construct(string $email, string $name, string $unitId, string $dateStart, string $dateEnd, string $postId, string $description, string $reportName = ReportName::REPORT_QUARTER)
    {
        $this->email = $email;
        $this->name = $name;
        parent::__construct($unitId, $dateStart, $dateEnd, $postId, $description, $reportName);
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    public function getQuarterReportRecipientDTO(): QuarterReportRecipientDTO
    {
        return new QuarterReportRecipientDTO(
            $this->email,
            $this->name,
            $this->name
        );
    }

}