<?php

namespace App\Models\Gallery;

use App\Core\ParamConverter\JsonModelConverter;
use Symfony\Component\Validator\Constraints as Assert;

class PhotoDetailsModel implements JsonModelConverter
{
    #[Assert\Type(type: 'string')]
    private ?string $title;

    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @param string|null $title
     * @return PhotoDetailsModel
     */
    public function setTitle(?string $title): PhotoDetailsModel
    {
        $this->title = $title;
        return $this;
    }


}