<?php

namespace App\Models\Agreement;

use App\Core\ParamConverter\JsonModelConverter;
use App\Entity\Agreement\Agreement;
use App\Entity\Agreement\AgreementID;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Serializer\Annotation\Ignore;
use Symfony\Component\Validator\Constraints as Assert;
use App\Core\Validator as CustomAssert;

class UserAgreementsModel implements JsonModelConverter
{
    /**
     * @Assert\All({
     *     @CustomAssert\EntityID(entityClass=Agreement::class)
     * })
     * @var string[] $agreements
     */
    private array $agreements;

    /**
     * @param string[] $agreements
     */
    public function setAgreements(array $agreements): void
    {
        $this->agreements = $agreements;
    }

    /**
     * @return AgreementID[]
     */
    #[Ignore]
    public function getAgreementsIDs(): array
    {
        return (new ArrayCollection($this->agreements))
            ->map(fn($agreementId) => AgreementID::fromString($agreementId))
            ->toArray();
    }
}