<?php

namespace App\Entity\Users\ReadModel;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Entity\Users\Helper\VolunteerBalanceHistoryDTO;
use App\Entity\Users\UserID;

interface VolunteersBalanceQueryInterface
{
    /**
     * @param UserID $userID
     * @param PaginationRequest $paginationRequest
     * @return VolunteerBalanceHistoryDTO[]
     */
    public function getVolunteerBalanceHistoryByUserID(UserID $userID, PaginationRequest $paginationRequest): array;

    /**
     * @param UserID $userID
     * @return VolunteerBalanceDTO
     */
    public function getVolunteerBalanceByUserID(UserID $userID): VolunteerBalanceDTO;

    /**
     * @return VolunteerDTO[]
     */
    public function getVolunteers(PaginationRequest $paginationRequest): array;

    /**
     * @param string $referenceCode
     * @return VolunteerDTO|null
     */
    public function getVolunteerByReferenceCode(string $referenceCode): ?VolunteerDTO;
}