<?php

namespace App\Entity\Users\ReadModel;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Entity\Users\UserID;

interface UsersQueryInterface
{
    /**
     * @param PaginationRequest $paginationRequest
     * @return UserDTO[]
     */
    public function findAllUsers(PaginationRequest $paginationRequest): array;

    /**
     * @param UserID $userID
     * @return PersonalDataDTO|null
     */
    public function findOneByUserID(UserID $userID): ?PersonalDataDTO;
}