<?php

namespace App\Entity\Users\Helper;

class UserStatus
{
    private const ACTIVE = 'active';
    private const NOT_ACTIVE = 'notActive';
    private const BLOCKED = 'blocked';

    public function __construct(
        private bool $isActive,
        private bool $isBlocked
    ) {}

    /**
     * @return bool
     */
    public function isActive(): bool
    {
        return $this->isActive;
    }

    /**
     * @return bool
     */
    public function isBlocked(): bool
    {
        return $this->isBlocked;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->isBlocked ? self::BLOCKED : ($this->isActive ? self::ACTIVE : self::NOT_ACTIVE);
    }
}