<?php

namespace App\Entity\Units\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;

class UnitDataDTO
{
    use FromArray;

    private function __construct(
        private string $title,
        private string $photo,
        private string $banner,
        private string $type,
        private string $purposeTitle,
        private int $moneyPurpose,
        private ?int $collectedMoney = 0,
        private ?int $children = 0,
        private ?int $supportedChildren = 0,
        private int $monthlyCost = 0,
        private ?string $userId = null
    ) {}

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getPhoto(): string
    {
        return $this->photo;
    }

    /**
     * @return string
     */
    public function getBanner(): string
    {
        return $this->banner;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return float
     */
    public function getMoneyPurpose(): float
    {
        return Money::toRational($this->moneyPurpose);
    }

    /**
     * @return float
     */
    public function getCollectedMoney(): float
    {
        return Money::toRational($this->collectedMoney);
    }

    /**
     * @return int
     */
    public function getChildren(): int
    {
        return $this->children;
    }

    /**
     * @return int
     */
    public function getSupportedChildren(): int
    {
        return $this->supportedChildren;
    }

    /**
     * @return string
     */
    public function getPurposeTitle(): string
    {
        return $this->purposeTitle;
    }

    /**
     * @return int
     */
    public function getMonthlyCost(): int
    {
        return Money::toRational($this->monthlyCost);
    }

    /**
     * @return bool
     */
    public function getUserIsRedactorPartner(): bool
    {
        return !empty($this->userId);
    }
}