<?php

namespace App\Entity\Subscriptions\ReadModel;

use App\Entity\Subscriptions\Helper\KindOfSubscription;

final class KindOfSubscriptionTranslations
{
    private static array $kindTranslations = [
        KindOfSubscription::CYCLIC => 'Cykliczna kartą',
        KindOfSubscription::ONE_TIME => 'Cykliczna przelew'
    ];

    public function __construct(
        private string $kindOfSubscription
    )
    {
    }

    public function __toString(): string
    {
        if (isset(self::$kindTranslations[$this->kindOfSubscription])) {
            return self::$kindTranslations[$this->kindOfSubscription];
        }

        return $this->getOriginalStatus();
    }

    public function getOriginalStatus(): string
    {
        return $this->kindOfSubscription;
    }
}