<?php

namespace App\Entity\Subscriptions\Helper;

class KindOfSubscription implements \JsonSerializable
{
    const CYCLIC = 'C';
    const ONE_TIME = 'O';

    public function __construct(
        public string $kindOfSubscription
    )
    {
    }

    public function isCyclic(): bool
    {
        return $this->kindOfSubscription === self::CYCLIC;
    }

    public function isOneTime(): bool
    {
        return $this->kindOfSubscription === self::ONE_TIME;
    }

    public function __toString(): string
    {
        return $this->kindOfSubscription;
    }

    public function jsonSerialize(): string
    {
        return $this->kindOfSubscription;
    }
}