<?php

namespace App\Entity\Subscriptions\Classes;

use App\Entity\Subscriptions\Helper\ReasonForClosure;
use App\Entity\Subscriptions\SubscriptionsInterface;
use App\Entity\Units\Unit;
use App\Entity\Users\User;

class SubscriptionManager implements SubscriptionManagerInterface
{

    public function __construct(
        private SubscriptionsInterface $subscriptions
    )
    {
    }

    public function deactivateSubscriptionsByUser(User $user): void
    {
        $subscriptions = $this->subscriptions->findAllActiveByUser($user);

        $this->deactivateSubscriptions($subscriptions, ReasonForClosure::ACCOUNT);
    }

    public function deactivateSubscriptionsByUnit(Unit $unit): void
    {
        $subscriptions = $this->subscriptions->findAllActiveByUnit($unit);

        $this->deactivateSubscriptions($subscriptions, ReasonForClosure::LOCK_UNIT);
    }

    private function deactivateSubscriptions(array $subscriptions, string $reason)
    {
        foreach ($subscriptions as $subscription) {
            $subscription->deactivate($reason);
        }
    }
}