<?php

namespace App\Entity\Sliders;

use App\Entity\SliderImages\SliderImage;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use PhpParser\Node\Expr\Closure;
use Symfony\Component\Uid\Uuid;

/**
 * @ORM\Entity()
 */
class Slider
{
    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private SliderID|Uuid $uuid;

    /**
     * @ORM\Column(type="integer")
     */
    private int $durationTime;

    /**
     * @ORM\OneToMany(targetEntity=SliderImage::class, mappedBy="slider")
     */
    private $sliderImages;


    public function __construct(SliderID $uuid, int $durationTime)
    {
        $this->uuid = $uuid;
        $this->durationTime = $durationTime;
        $this->sliderImages = new ArrayCollection();
    }

    /**
     * @return SliderID
     */
    public function getUuid(): SliderID
    {
        return SliderID::fromString($this->uuid);
    }

    /**
     * @return int
     */
    public function getDurationTime(): int
    {
        return $this->durationTime;
    }

    /**
     * @param int $durationTime
     */
    public function setDurationTime(int $durationTime): void
    {
        $this->durationTime = $durationTime;
    }

    /**
     * @return Collection|SliderImage[]
     */
    public function getSliderImages(): Collection
    {
        return $this->sliderImages;
    }

    public function addSliderImage(SliderImage $sliderImage): self
    {
        if (!$this->sliderImages->contains($sliderImage)) {
            $this->sliderImages[] = $sliderImage;
            $sliderImage->setSlider($this);
        }

        return $this;
    }

    public function removeSliderImage(SliderImage $sliderImage): self
    {
        if ($this->sliderImages->removeElement($sliderImage)) {
            // set the owning side to null (unless already changed)
            if ($sliderImage->getSlider() === $this) {
                $sliderImage->setSlider(null);
            }
        }

        return $this;
    }
}
