<?php

namespace App\Entity\Roles\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\Roles\RoleID;

class RoleDTO
{
    use FromArray;

    private function __construct(
        private string $roleId,
        private string $name
    ) {
        $this->roleId = (string) RoleID::fromString($this->roleId);
    }

    /**
     * @return string
     */
    public function getRoleId(): string
    {
        return $this->roleId;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }
}