<?php

namespace App\Entity\Reports\Helper;

use App\Core\PdfGenerator\PDFParametersBuilderInterface;
use App\Entity\Reports\ReadModel\AnnualReportOrderDTO;

class AnnualReportParameters implements PDFParametersBuilderInterface
{
    /**
     * @var AnnualReportOrderDTO[]
     */
    private array $orders;

    private float $summaryPrice = 0;

    public function __construct(
        private string $year,
        private string $name,
        private string $surname,
        private string $email,
        array $orders = [],
    )
    {
        $this->orders = $orders;
        foreach ($this->getOrders() as $order) {
            $this->summaryPrice = $this->summaryPrice +$order->getPrice();
        }
    }

    /**
     * @return string
     */
    public function getYear(): string
    {
        return $this->year;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getSurname(): string
    {
        return $this->surname;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return AnnualReportOrderDTO[]
     */
    public function getOrders(): array
    {
        return $this->orders;
    }


    public function getSummaryPrice(): float
    {
        return $this->summaryPrice;
    }


    public function getParameters(): array
    {
        return get_object_vars($this);
    }
}