<?php

namespace App\Entity\Purposes\ReadModel;

use App\Core\Utils\Money;
use App\Entity\Purposes\PurposeID;

class PurposeDetailsDTO
{
    public function __construct(
        private string $purposeId,
        private string $purposeTitle,
        private int $moneyPurpose,
        private int $collectedMoney,
        private string $purposeContent
    ) {
        $this->purposeId = (string) PurposeID::fromString($this->purposeId);
    }

    /**
     * @return string
     */
    public function getPurposeId(): string
    {
        return $this->purposeId;
    }

    /**
     * @return string
     */
    public function getPurposeTitle(): string
    {
        return $this->purposeTitle;
    }

    /**
     * @return float
     */
    public function getMoneyPurpose(): float
    {
        return Money::toRational($this->moneyPurpose);
    }

    /**
     * @return float
     */
    public function getCollectedMoney(): float
    {
        return Money::toRational($this->collectedMoney);
    }

    /**
     * @return string
     */
    public function getPurposeContent(): string
    {
        return $this->purposeContent;
    }
}