<?php

namespace App\Entity\Purposes\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\Units\Helper\Type;

class GoalsListDTO
{
    use FromArray;

    private Type $type;

    private function __construct(
                string $type,
        private string $purposeId,
        private string $purposeTitle,
        private int $moneyPurpose,
        private string $purposeContent,
        private ?string $hearthAdoptionId = null,
        private ?int $collectedMoney = 0,
        private ?int $children = 0,
        private ?int $supportedChildren = 0,
        private ?string $adoptionContent = null,
        private ?int $monthlyCost = 0
    ) {
        $this->type = new Type($type);
    }

    public function getPurpose(): PurposeDetailsDTO
    {
        return new PurposeDetailsDTO(
            $this->purposeId,
            $this->purposeTitle,
            $this->moneyPurpose,
            $this->collectedMoney,
            $this->purposeContent
        );
    }

    public function getHeartAdoption(): ?HeartAdoptionDetailsDTO
    {
        if ($this->type->hasSubscriptionOrders()) {
            return new HeartAdoptionDetailsDTO(
                $this->hearthAdoptionId,
                $this->children,
                $this->supportedChildren,
                $this->adoptionContent,
                $this->monthlyCost
            );
        }

        return null;
    }
}