<?php

namespace App\Entity\Orders\ReadModel;

use App\Entity\Orders\Helper\OrderAction;
use App\Entity\Subscriptions\Helper\KindOfSubscription;

class OrderActionTranslations
{
    private static array $orderActionTranslations = [
        OrderAction::PURPOSE => 'Jednorazowa',
        OrderAction::HEARTH_ADOPTION => 'Subskrypcja',
        KindOfSubscription::CYCLIC => 'Cykliczna kartą',
        KindOfSubscription::ONE_TIME => 'Cykliczna przelew'
    ];

    public function __construct(
        private string $orderAction
    )
    {
    }

    public function __toString(): string
    {
        if (isset(self::$orderActionTranslations[$this->orderAction])) {
            return self::$orderActionTranslations[$this->orderAction];
        }

        return $this->getOriginalStatus();
    }

    public function getOriginalStatus(): string
    {
        return $this->orderAction;
    }
}