<?php

namespace App\Entity\Orders\Helper;

class OrderAction implements \JsonSerializable
{
    const PURPOSE = 'P';
    const HEARTH_ADOPTION = 'A';

    public function __construct(private string $orderAction)
    {
    }

    public function isPurpose(): bool
    {
        return $this->orderAction === self::PURPOSE;
    }

    public function isHearthAdoption(): bool
    {
        return $this->orderAction === self::HEARTH_ADOPTION;
    }

    public function __toString(): string
    {
        return $this->orderAction;
    }

    public function jsonSerialize(): string
    {
        return $this->orderAction;
    }

}