<?php

namespace App\Entity\Orders\Events;

use App\Entity\Orders\Order;
use Symfony\Contracts\EventDispatcher\Event;

class OrderVerifyEvent extends Event
{
    public const NAME = 'order.verify';

    protected $order;

    public function __construct(?Order $order)
    {
        $this->order = $order;
    }

    public function getOrder(): ?Order
    {
        return $this->order;
    }
}