<?php

namespace App\Entity\Orders\Classes;

use App\Entity\Orders\Order;
use App\Entity\Orders\OrderID;
use App\Entity\Subscriptions\Subscription;
use App\Entity\Units\Unit;
use App\Entity\Users\User;

interface OrderBuilderInterface
{
    //TODO REMOVE INTERFACE AFTER REVIEW
    public function create(): self;

    public function update(Order $order): self;

    public function setUuid(OrderID $orderID): self;

    /**
     * @param User|null $user
     */
    public function setUser(?User $user): self;

    /**
     * @param Unit $unit
     */
    public function setUnit(Unit $unit): self;


    /**
     * @param Subscription|null $subscription
     */
    public function setSubscription(?Subscription $subscription): self;

    /**
     * @param string $status
     */
    public function setStatus(string $status): self;

    /**
     * @param int $amount
     */
    public function setAmount(int $amount): self;

    /**
     * @param string $action
     */
    public function setAction(string $action): self;


    /**
     * @param string $token
     */
    public function setToken(string $token): self;


    /**
     * @param \DateTimeImmutable|null $verifiedAt
     */
    public function setVerifiedAt(?\DateTimeImmutable $verifiedAt): self;


    /**
     * @param string|null $externalID
     */
    public function setExternalID(?string $externalID): self;

    public function getOrder(): Order;
}