<?php

namespace App\Entity\BankStatement;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\Entity;
use Symfony\Component\Uid\Uuid;
use App\Entity\Units\Unit;

/**
 * @Entity()
 */
class BankStatement
{
    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private BankStatementID|Uuid $uuid;

    /**
     * @ORM\Column(type="string", length=20)
     */
    private string $erp_transaction_code;

    /**
     * @ORM\Column(type="string", length=20)
     */
    private string $mbank_transaction_code;


    /**
     * @ORM\Column(type="string", length=50)
     */
    private string $account_number;

    /**
     * @ORM\Column(type="string", length=200)
     */
    private string $client_name;

    /**
     * @ORM\Column(type="integer")
     */

    private string $amount;

    /**
     * @ORM\Column(type="string", length=10)
     */
    private string $currency;

    /**
     * @ORM\Column(type="string", length=50)
     */
    private string $transaction_side;

    /**
     * @ORM\Column(type="string", length=50)
     */
    private string $accounting_date;


    /**
     * @ORM\Column(type="string", length=50)
     */
    private string $register_date;


    /**
     * @ORM\Column(type="string", length=50)
     */
    private string $account_number_from;


    /**
     * @ORM\Column(type="string", length=50)
     */
    private string $contractor;

    /**
     * @ORM\Column(type="string", length=500)
     */
    private string $transaction_desc;


    /**
     * @ORM\Column(type="string", length=500)
     */
    private string $transaction_desc_full;


    /**
     * @ORM\Column(type="string", length=50)
     */
    private string $transaction_id;


    /**
     * @ORM\Column(type="string", length=0)
     */
    private string $client_references;



    /**
     * @ORM\ManyToOne(targetEntity=Unit::class)
     * @ORM\JoinColumn(name="unit_id", referencedColumnName="uuid", nullable=true)
     */
    private ?Unit $unit;

    /**
     * @ORM\Column(type="datetime_immutable")
     */
    private \DateTimeImmutable $createdAt;

    /**
     * @param string $image
     */
    public function __construct(string $image)
    {
        $this->uuid = BankStatementID::generate();
        //$this->image = $image;
        $this->createdAt = new \DateTimeImmutable();
    }

    /**
     * @return BankStatementID
     */
    public function getUuid(): BankStatementID
    {
        return BankStatementID::fromString($this->uuid);
    }

 }