<?php

namespace App\Entity\BalanceOperations\Helper;

final class Type implements \JsonSerializable
{
    const PAYMENT_HEARTH_ADOPTION_CYCLIC = 'C';
    const PAYMENT_PURPOSE = 'P';
    const PAYMENT_HEARTH_ADOPTION_ONE_TIME = 'O';
    const ADMIN_OPERATION = 'A';

    public function __construct(private string $type)
    {
    }

    public function isCyclic(): bool
    {
        return $this->type === self::PAYMENT_HEARTH_ADOPTION_CYCLIC;
    }

    public function isPurpose(): bool
    {
        return $this->type === self::PAYMENT_PURPOSE;
    }

    public function isOneTime(): bool
    {
        return $this->type === self::PAYMENT_HEARTH_ADOPTION_ONE_TIME;
    }

    public function isAdminOperation(): bool
    {
        return $this->type === self::ADMIN_OPERATION;
    }

    public function __toString(): string
    {
        return $this->type;
    }

    public function jsonSerialize(): string
    {
        return $this->type;
    }

}