<?php

namespace App\DataFixtures;

use App\Entity\Permissions\Permission;
use App\Entity\Roles\Factory\RoleFactory;
use App\Entity\Roles\Role;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Persistence\ObjectManager;

class VolunteerRoleFixtures extends Fixture implements OrderedFixtureInterface
{

    public function load(ObjectManager $manager)
    {
        $repository = $manager->getRepository(Permission::class);
        $role = RoleFactory::create('Wolontariusz', Role::VOLUNTEER);

        $permissions = $repository->findBy(['authorization' => Permission::VOLUNTEER_PERMISSIONS]);
        $this->addPermissionToRole($role, $permissions);

        $manager->persist($role);

        $manager->flush();
    }

    private function addPermissionToRole(Role $role, array $permissions): void
    {
        foreach ($permissions as $permission) {
            $role->addPermission($permission);
        }
    }

    public function getOrder(): int
    {
        return 6;
    }
}