<?php

namespace App\DataFixtures;

use App\Entity\Agreement\Agreement;
use App\Entity\Agreement\Factory\AgreementFactory;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Persistence\ObjectManager;

class AgreementFixtures extends Fixture implements OrderedFixtureInterface
{
    const AGREEMENTS = [
        Agreement::COMMERCIAL_INFORMATION => [
            'Wyrażam zgodę na przesyłanie mi informacji marketingowych dotyczących produktów i usług oferowanych przez "PALLOTYŃSKA FUNDACJA MISYJNA SALVATTI.PL" za pomocą środków komunikacji elektronicznej, stosownie do treści przepisu art. 10 ust. 1 i 2 ustawy o świadczeniu usług drogą elektroniczną.' => false
        ],
        Agreement::ONE_TIME_SUBSCRIPTION_EXPIRING => ['Powiadomcie mnie o kończących się subskrypcjach opłaconych z góry.' => true],
        Agreement::CARD_WITHDRAW_PROBLEM => ['Powiadomcie mnie o problemach z pobraniem środków z karty płatniczej.' => true],
//        Agreement::QUARTERLY_REPORT_SUPPORTED_UNIT => ['Przesyłajcie mi raporty dotyczące wspieranych przeze mnie zbiórek.' => true],
    ];

    public function load(ObjectManager $manager)
    {
        foreach (self::AGREEMENTS as $agreementOriginalName => $agreementDetails) {
            $agreementEntity = AgreementFactory::create(
                $agreementOriginalName,
                key($agreementDetails),
                current($agreementDetails)
            );

            $manager->persist($agreementEntity);
        }

        $manager->flush();
    }

    public function getOrder(): int
    {
        return 3;
    }
}
