<?php

namespace App\Core\Voter;

use App\Entity\Permissions\Helper\PermissionChecker;
use App\Entity\Permissions\Permission;
use App\Entity\Users\User;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;

class PrivateAccessVoter extends Voter
{
    protected function supports(string $attribute, $subject): bool
    {
        return $subject instanceof User && $this->canUsePrivateAccess($attribute);
    }

    protected function voteOnAttribute(string $attribute, $subject, TokenInterface $token): bool
    {
        return $subject->getUuid() == $token->getUser()->getUuid();
    }

    private function canUsePrivateAccess(string $attribute): bool
    {
        return PermissionChecker::isPrivate($attribute);
    }
}