<?php

namespace App\Core\ValidatorModel;

use App\Core\Exception\ApiException;
use Symfony\Component\Validator\Validator\ValidatorInterface;

class ValidatorModel implements ValidatorModelInterface
{

    public function __construct(
        private ValidatorInterface $validator
    )
    {
    }

    public function validate($value, $constraints = null, $groups = null): void
    {
        $validationErrors = $this->validator->validate($value, $constraints, $groups);

        if (count($validationErrors) > 0) {
            throw ApiException::fromErrors($validationErrors);
        }
    }
}