<?php

namespace App\Core\Validator;

use Symfony\Component\Validator\Constraint;

/**
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 */
#[\Attribute]
class EntityID extends Constraint
{
    public string $message = 'The entity "{{ entity }}" with "{{ uuid }}" not found';
    public string $messageUuid = 'This is not a valid UUID. "{{ message }}"';

    public mixed $entityClass;

    /**
     * EntityID constructor.
     * @param array|null $options
     * @param array|null $groups
     * @param null $payload
     * @param $entityClass
     */
    public function __construct(
        $entityClass = null,
        array $options = null,
        array $groups = null,
        $payload = null
    ) {
        parent::__construct($options, $groups, $payload);
        $this->entityClass = $entityClass;
    }
}