<?php

namespace App\Core\Utils;

trait FromArray
{
    private ?int $totalRow = null;

    /** @throws \ReflectionException */
    public static function fromArray(array $data): static
    {
        $reflectionMethod = new \ReflectionMethod(static::class, '__construct');
        $reflectionParameters = $reflectionMethod->getParameters();
        $parameters = [];

        foreach ($reflectionParameters as $reflectionParameter) {
            $parameterName = $reflectionParameter->getName();

            if (!\array_key_exists($parameterName, $data) && !$reflectionParameter->isOptional()) {
                throw new \LogicException(
                    'Unable to instantiate \'' . static::class . '\' from an array, argument ' . $parameterName .' is missing.
                     Only the following arguments are available: ' . implode(', ', \array_keys($data))
                );
            }

            $parameter = $data[$parameterName] ?? $reflectionParameter->getDefaultValue();

            if (\is_array($parameter) && $reflectionParameter->isVariadic()) {
                $parameters = \array_merge($parameters, $parameter);
                continue;
            }

            $parameters[] = $parameter;
        }

        $classInstance = new static(...$parameters);
        $classInstance->setTotalRow($data['totalRow'] ?? null);
        return $classInstance;
    }

    /**
     * @return int|null
     */
    public function totalRow(): ?int
    {
        return $this->totalRow;
    }

    /**
     * @param int|null $totalRow
     */
    public function setTotalRow(?int $totalRow): void
    {
        $this->totalRow = $totalRow;
    }
}