<?php

namespace App\Core\Users;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Users\User;
use App\Services\LoginUserHistories\CreateLoginHistory;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Core\Exception\CustomUserMessageAccountStatusException;
use Symfony\Component\Security\Core\User\UserCheckerInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

class UserLoginChecker implements UserCheckerInterface
{
    public function __construct(
        private TranslatorInterface $translator,
        private CreateLoginHistory $loginHistory
    ) {}

    public function checkPreAuth(UserInterface $user): void
    {
        if (!$user instanceof User) {
            return;
        }

        if ($user->getIsNotActive()) {
            throw new CustomUserMessageAccountStatusException(
                $this->translator->trans('account.not_activated')
            );
        }

        if ($user->getIsBlocked()) {
            throw new CustomUserMessageAccountStatusException(
                $this->translator->trans('account.blocked')
            );
        }
    }

    public function checkPostAuth(UserInterface $user): void
    {
        if (!$user instanceof User) {
            return;
        }

        $clientIp = (Request::createFromGlobals())->getClientIp();

        /** @var User $user */
        $this->loginHistory->create($user, $clientIp);
    }
}