<?php


namespace App\Core\PdfGenerator;


use App\Core\PdfGenerator\Exceptions\GenerationErrorException;
use Dompdf\Dompdf;
use Dompdf\Options;
use Twig\Environment;

class PDFGenerator implements PDFGeneratorInterface
{
    /**
     * @var Environment
     */
    private $environment;

    public function __construct(
        Environment $environment
    )
    {
        $this->environment = $environment;
    }

    public function generate(
        PDFFile $PDFFile
    ): void
    {
        try {
            $options = new Options();
            $options->setIsRemoteEnabled(true);
            $dompdf = new Dompdf($options);

            $html = $this->environment->render(
                $PDFFile->getTwigName(),
                $PDFFile->getTwigParameters()
            );

            $dompdf->loadHtml($html);

            $dompdf->setPaper($PDFFile->getPaperFormat(), $PDFFile->getOrientation());

            $dompdf->render();

            $this->createIfOutputPathNotExists($PDFFile->getFilePath());

            file_put_contents(
                $PDFFile->getFilePath() . $PDFFile->getFileName(),
                $dompdf->output()
            );
        } catch (\Throwable $e) {
            throw new GenerationErrorException($e);
        }
    }

    private function createIfOutputPathNotExists(string $outputPath): void
    {
        if (!file_exists($outputPath)) {
            mkdir($outputPath, 0775, true);
        }
    }
}