<?php


namespace App\Core\PdfGenerator;


interface PDFBuilderInterface
{
    public static function create(string $fileName, string $filePath, string $twigName): PDFBuilder;

    public function setTwigParameters(PDFParametersBuilderInterface $PDFParametersBuilder): PDFBuilder;

    public function changeOrientationToLandscape(): PDFBuilder;

    public function changePaperFormat(string $paperFormat): PDFBuilder;

    public function build(): PDFFile;
}