<?php

namespace App\Core\Paginator\ObjectValue;

use Symfony\Component\HttpFoundation\Request;

class PaginationRequest
{
    private ?int $pageNumber;
    private ?int $itemPerPage;

    private function __construct(Request $request) {
        $pageNumber = (int)$request->get('page');
        $this->pageNumber = $pageNumber > 0 ? $pageNumber : null;

        $itemPerPage = (int)$request->get('perPage');
        $this->itemPerPage = $itemPerPage > 0 ? $itemPerPage : null;
    }

    public static function build(Request $request): self
    {
        return new self($request);
    }

    /**
     * @return int|null
     */
    public function getPageNumber(): ?int
    {
        return $this->pageNumber;
    }

    /**
     * @return int|null
     */
    public function getItemPerPage(): ?int
    {
        return $this->itemPerPage;
    }

    /**
     * @return int
     */
    public function getPagingFirstResultParameter(): int
    {
        return ($this->pageNumber - 1) * $this->itemPerPage;
    }

    /**
     * @return int
     */
    public function getLoadMoreMaxResultParameter(): int
    {
        return $this->pageNumber * $this->itemPerPage;
    }

    public function isValid(): bool
    {
        return $this->pageNumber && $this->itemPerPage;
    }
}