<?php

namespace App\Core\File\FileUploader;

use App\Core\File\FileToUpload\FileToUploadInterface;
use Symfony\Component\Filesystem\Filesystem;

class FileUploader implements FileUploaderInterface
{
    private const CHMOD = 0777;

    public function __construct(
        private string $fileUploadDir,
        private Filesystem $filesystem
    ) {}

    public function upload(FileToUploadInterface $fileToUpload): void
    {
        if (!$this->filesystem->exists($this->fileUploadDir)) {
            mkdir($this->fileUploadDir, self::CHMOD);
        }

        $filePath = $this->fileUploadDir . $fileToUpload->getUniqueName();

        $this->filesystem->dumpFile(
            $filePath,
            $fileToUpload->getContent()
        );
    }
}