<?php

namespace App\Core\File\FileToUpload;

use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;

class ImageToUpload implements FileToUploadInterface
{
    private const IMAGE_MAX_SIZE = '3M';
    private const IMAGE_MIME_TYPES = ['image/png', 'image/jpeg'];

    #[Assert\Image(
        maxSize: self::IMAGE_MAX_SIZE,
        mimeTypes: self::IMAGE_MIME_TYPES,
        groups: ['Default']
    )]
    private UploadedFile $uploadedFile;
    private string $uniqueImageName;

    public function __construct(UploadedFile $uploadedFile)
    {
        $this->uploadedFile = $uploadedFile;
        $this->uniqueImageName = uniqid() . '-' . $this->uploadedFile->getClientOriginalName();
    }

    public function getUniqueName(): string
    {
        return $this->uniqueImageName;
    }

    public function getContent(): string
    {
        return $this->uploadedFile->getContent();
    }
}