<?php

namespace App\Core\Doctrine;

use Doctrine\DBAL\Query\QueryBuilder;

class SubQueryBuilder
{
    private function __construct(
        private QueryBuilder $subQuery,
        private QueryBuilder $mainQuery
    ) {
        $this->setParametersOnMainQuery();
    }

    public static function prepare(QueryBuilder $subQuery, QueryBuilder $mainQuery): SubQueryBuilder
    {
        return new SubQueryBuilder($subQuery, $mainQuery);
    }

    public function __toString(): string
    {
        return sprintf('(%s)', $this->subQuery->getSQL());
    }

    private function setParametersOnMainQuery(): void
    {
        foreach ($this->subQuery->getParameters() as $parameterName => $parameterValue) {
            $this->mainQuery->createNamedParameter(
                $parameterValue,
                $this->subQuery->getParameterType($parameterName),
                ':' . $parameterName
            );
        }
    }
}