<?php


namespace App\Core;


use Symfony\Component\Uid\Uuid;
use Symfony\Component\Uid\UuidV4;

abstract class AbstractUUID extends Uuid
{
    public function __construct(
        string $id
    )
    {
        parent::__construct($id);
    }

    abstract public static function generate();

    public static function uuidV4(): UuidV4
    {
        return Uuid::v4();
    }

}