<?php

namespace App\Controller\Users\Update;

use App\Entity\Permissions\Permission;
use App\Entity\Users\User;
use App\Models\Agreement\UserAgreementsModel;
use App\Services\Agreement\UpdateUserAgreement;
use Nelmio\ApiDocBundle\Annotation\Model;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Users")
 */
#[Route('/api/users', name: 'users_')]
class UpdateUserAgreementController extends AbstractController
{
    public function __construct(
        private UpdateUserAgreement $updateAgreement
    ) {}

    /**
     * @OA\Put(summary="Assign agreement")
     * @OA\RequestBody(
     *      @Model(type=UserAgreementsModel::class),
     *     description="Array must contain the checked agreementId"
     * )
     */
    #[IsGranted(Permission::ACCOUNT_DATA_MANAGEMENT)]
    #[IsGranted(Permission::PRIVATE_ACCESS, 'user')]
    #[Route(path: '/{userId}/agreements', name: 'update_agreement', methods: ['PUT'])]
    #[ParamConverter('user', options: ['mapping' => ['userId' => 'uuid']])]
    public function update(
        User $user,
        UserAgreementsModel $userAgreementsModel,
        Request $request
    ): JsonResponse
    {
        $this->updateAgreement->update(
            $userAgreementsModel,
            $user,
            $request->getClientIp()
        );
        return $this->json('Agreement has been updated');
    }
}