<?php

namespace App\Controller\Users\Data;

use App\Entity\Agreement\ReadModel\AgreementsQueryInterface;
use App\Entity\Permissions\Permission;
use App\Entity\Users\User;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Users")
 */
#[Route('/api/users', name: 'users_')]
class UserAgreementDataController extends AbstractController
{
    public function __construct(
        private AgreementsQueryInterface $agreementsQuery
    )
    {
    }

    /**
     * @OA\Get(summary="Show user agreements")
     */
    #[IsGranted(Permission::ACCOUNT_DATA_MANAGEMENT)]
    #[IsGranted(Permission::PRIVATE_ACCESS, 'user')]
    #[Route(path: '/{userId}/agreements', name: 'show_agreements', methods: ['GET'])]
    #[ParamConverter('user', options: ['mapping' => ['userId' => 'uuid']])]
    public function show(User $user): JsonResponse
    {
        return $this->json(
            $this->agreementsQuery->findAllUserAgreements(
                $user->getUuid()
            )
        );
    }
}