<?php

namespace App\Controller\Users\Create;

use App\Entity\Permissions\Permission;
use App\Entity\Users\User;
use App\Models\BalanceOperations\CreateBalanceOperationModel;
use App\Services\BalanceOperations\CreateBalanceOperation;
use OpenApi\Annotations as OA;
use Nelmio\ApiDocBundle\Annotation\Model;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/** @OA\Tag(name="Volunteers") */
#[Route('/api/volunteers', name: 'volunteers_')]
class CreateVolunteerBalanceOperationController extends AbstractController
{
    public function __construct(
        private CreateBalanceOperation $createBalanceOperation,
    )
    {
    }

    /**
     * @OA\Get(summary="Create volunteer balance operation")
     * @OA\RequestBody(
     *     @Model(type=CreateBalanceOperationModel::class)
     * )
     */
    #[IsGranted(Permission::ACCOUNT_DATA_MANAGEMENT)]
    #[Route(path: '/{volunteerId}/balance-operations', name: 'create_balance_operation', methods: ['POST'])]
    #[ParamConverter('user', options: ['mapping' => ['volunteerId' => 'uuid']])]
    #[ParamConverter('balanceOperationModel', converter: "json_deserialize_param_converter")]
    public function createBalanceOperation(User $user, CreateBalanceOperationModel $balanceOperationModel): JsonResponse
    {
        /** @var User $admin */
        $admin = $this->getUser();

        $balanceOperation = $this->createBalanceOperation->create($admin, $user, $balanceOperationModel);
        return $this->json(['balanceOperationID' => $balanceOperation->getUuid()]);
    }
}